/*
 * Copyright (C) Jan 2006 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *  CrSpace.h - CR-SPACE representation class
 *
 *  Version: $Id: CrSpace.h 2752 2006-01-19 14:40:17Z mst $
 *
 */
#include <map>
#include <vector>
#include <algorithm>

#include "compatibility.h"
#include "utils.h"

#ifndef CRSPACE_H
#define CRSPACE_H

class Param;
class CrSpace : public ErrMsg
{
public:
    CrSpace()  { }
    ~CrSpace() { }

    static bool  warn;   // print warnings
    static bool  par_debug() { return _par_debug; }
    static bool  cr_debug()  { return _cr_debug;  }
    static bool  bl_debug()  { return _bl_debug;  }
    static void  set_debugs();

    bool add(Param* par, const u_int32_t bitoffs,
             const u_int32_t bitsize, u_int32_t value);
    bool create_inits(bool only_rmw = false);

    std::vector<u_int32_t> iwi_init;  // Individual words initialization
    std::vector<u_int32_t> hbi_init;  // Homogeneous block initialization
    std::vector<u_int32_t> nbi_init;  // Non-homogeneous block initialization
    std::vector<u_int32_t> rmw_init;  // Read-modify-write block initialization

protected:
    static bool _par_debug;
    static bool _cr_debug;
    static bool _bl_debug;

    enum { BLOCK_TRESHOLD = 4,  // After this number of words, block is created
           HOMOG_TRESHOLD = 4   // After this number of same words,
                                // in non-homogeneous block, homogeneous block
                                // is created
    };
private:
    void generate_block(const u_int32_t addr, std::vector<u_int32_t>& block);

    class Chunk
    {
    public:
        Chunk(Param* par, const u_int32_t bitsize, u_int32_t value);
        Chunk(const Chunk& old)
        {
            v = old.v;
            p = old.p;
        }
        Chunk& operator= (const Chunk& old)
        {
            v = old.v;
            p = old.p;
            return *this;
        }

        std::vector<bool> v;
        Param             *p;
    };

    #ifndef TAVOR_DEBUG
    typedef std::map<u_int32_t, Chunk> Cr;
    #else
    typedef std::vector<std::pair<u_int32_t, Chunk> > Cr;
    class SortAscending {
        public:
            bool operator()(const std::pair<u_int32_t, Chunk>& p1, const std::pair<u_int32_t, Chunk>& p2) {
        	return p1.first < p2.first;
            }
    };
    #endif


    Cr _cr;
};

#endif
